/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Label;
import com.sun.lwuit.MonthView;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Date;
import java.util.Hashtable;

public class Calendar
extends Container {
    private Label month;
    private Label year;
    private MonthView mv;
    private static String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public Calendar(long time) {
        super(new BorderLayout());
        Container upper = new Container(new FlowLayout(4));
        this.mv = new MonthView(time, this);
        this.month = new Label(MONTHS[this.mv.getMonth()]);
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(new Date(time));
        this.month.getStyle().setBgTransparency(0);
        int y = cal.get(1);
        this.year = new Label("" + y);
        this.year.getStyle().setBgTransparency(0);
        Container cnt = new Container(new BoxLayout(1));
        cnt.addComponent(this.month);
        cnt.addComponent(this.year);
        upper.addComponent(cnt);
        this.addComponent("North", (Component)upper);
        this.addComponent("Center", (Component)this.mv);
    }

    public Calendar() {
        this(System.currentTimeMillis());
    }

    protected String getUIID() {
        return "Calendar";
    }

    public long getSelectedDay() {
        return this.mv.getSelectedDay();
    }

    void componentChanged() {
        Object o;
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.set(1, this.mv.getYear());
        cal.set(2, this.mv.getMonth());
        cal.set(5, this.mv.getDayOfMonth());
        Hashtable t = UIManager.getInstance().getResourceBundle();
        String text = MONTHS[this.mv.getMonth()];
        if (t != null && (o = t.get("Calendar." + text)) != null) {
            text = (String)o;
        }
        this.month.setText(text);
        this.year.setText("" + this.mv.getYear());
        this.month.getParent().revalidate();
    }

    public Date getDate() {
        return new Date(this.mv.getSelectedDay());
    }

    public void setDate(Date d) {
        this.mv.setSelectedDay(d.getTime());
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public void refreshTheme() {
        this.mv.refreshTheme();
    }

    public void setStyle(Style s) {
        super.setStyle(s);
        this.month.setStyle(s);
        this.year.setStyle(s);
    }

    public void setMonthViewStyle(Style s) {
        this.mv.setStyle(s);
    }

    public Style getMonthViewStyle() {
        return this.mv.getStyle();
    }

    public void addActionListener(ActionListener l) {
        this.mv.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.mv.removeActionListener(l);
    }

    public void addDataChangeListener(DataChangedListener l) {
        this.mv.addDataChangeListener(l);
    }

    public void removeDataChangeListener(DataChangedListener l) {
        this.mv.removeDataChangeListener(l);
    }
}

